//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: abaptist
//
// Date: Sep 27, 2007
//---------------------

package org.cleversafe.layer.communication.policy;

import org.apache.log4j.Logger;
import org.cleversafe.layer.communication.Connector;
import org.cleversafe.layer.communication.ConnectorManager;
import org.cleversafe.layer.communication.exceptions.CommunicationConnectionException;
import org.cleversafe.layer.communication.exceptions.CommunicationIOException;
import org.cleversafe.layer.communication.exceptions.CommunicationInterruptedException;

/**
 * A simple connector manager does not have all the complicated retry logic of a smart connector. It
 * is primarily intended for testing, but could possibly be used in a situation where network issues
 * are very uncommon.
 * 
 * @author Andrew Baptist <abaptist@cleversafe.com>
 * @version $Id$
 */
public class SimpleConnectorManager implements ConnectorManager
{
   private static Logger _logger = Logger.getLogger(SimpleConnectorManager.class);
   private Connector connection;

   public synchronized boolean ensureConnected() throws CommunicationIOException,
         CommunicationConnectionException
   {
      if (!connection.isConnected())
      {
         try
         {
            connection.connect();
         }
         catch (final CommunicationIOException ex)
         {
            _logger.warn("Communication IO exception encountered while reconnecting: " + ex.getMessage());
         }

         // Check if connection was re-established
         if (connection.isConnected() == true)
         {
            _logger.debug("Connection re-established");
            return true;
         }
         throw new CommunicationConnectionException("Unable to connect");

      }

      return false;
   }

   public synchronized void onError()
   {
      try
      {
         if (connection.isConnected())
         {
            connection.disconnect();
         }
      }
      catch (CommunicationIOException e)
      {
         _logger.warn("IOException caught while disconnecting because of error");
      }
      catch (CommunicationInterruptedException e)
      {
         _logger.warn("CommunicationInterruptedException caught while disconnecting because of error");
      }

   }

   public void onConnectorInit()
   {
      // nothing to do for simple connector
   }

   public void onSuccess()
   {
      // nothing to do for simple connector
   }

   public void setConnection(Connector connection)
   {
      this.connection = connection;
   }

}
