//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 16, 2007
//---------------------

package org.cleversafe.layer.grid;

import org.cleversafe.layer.grid.exceptions.ControllerException;
import org.cleversafe.vault.Vault;

// Defines common part of all controllers: the fact they operate on a vault
public abstract class OperationControllerBase implements OperationController
{
   //private static Logger _logger = Logger.getLogger(OperationControllerBase.class);
   private Vault vault;
   private boolean shutdown =  false;
 
   public OperationControllerBase(Vault vault)
   {
      assert vault != null : "Controller can't operate on undefined Vault";
      this.vault = vault;
   }
   /**
    * 
    * @return associated vault
    */
   public Vault getVault()
   {
      assert vault != null : "Vault must be set before use";
      return vault;
   }
   /**
    * 
    * @param vault
    */
   public void setVault(Vault vault)
   {
      assert vault != null : "Vault must be defined";
      this.vault = vault;
   }
   
   protected void setShutdown()
   {
      this.shutdown = false;
   }
   /**
    * Checks whether a controller can be used
    * @return
    */
   public boolean isOperational()
   {
      return this.vault != null && !this.shutdown;
   }
   /**
    * Specialized to each controller method to complete its operations
    * @throws ControllerException
    */
   protected void doShutdown() throws ControllerException
   {
      
   }
   /**
    * shutdown controller, would be executed only once. Should be invoked only once
    * There is a potential race on shutdown variable, but with correct usage it should not be a problem
    * @return 
    * @throws ControllerException
    */
   public final synchronized void shutdown() throws ControllerException
   { 
      if (this.shutdown)
         return;
      this.shutdown = true;
      doShutdown();
   }


}


