//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Aug 23, 2007
//---------------------

package org.cleversafe.layer.grid;

import org.cleversafe.serialization.GridSerializable;

/**
 * The name of a slice on the grid
 */
public class SliceName implements GridSerializable
{
   // Name of the slice's datasource
   private SourceName sourceName = null;

   // Index of this slice in the IDA
   private int sliceIndex = -1;

   public SliceName()
   {
   }

   /**
    * Construct a slice name for a given source and index
    * 
    * @param sourceName
    * @param sliceIndex
    */
   public SliceName(SourceName sourceName, int sliceIndex)
   {
      this.sourceName = sourceName;
      this.sliceIndex = sliceIndex;
   }

   /**
    * Convenience constructor.
    * 
    * @param name
    * @param sliceIndex
    */
   public SliceName(String name, int sliceIndex)
   {
      this(new SourceName(name), sliceIndex);
   }

   public SourceName getSourceName()
   {
      return this.sourceName;
   }

   public int getSliceIndex()
   {
      return this.sliceIndex;
   }

   public void setSourceName(SourceName sourceName)
   {
      this.sourceName = sourceName;
   }

   public void setSliceIndex(int sliceIndex)
   {
      this.sliceIndex = sliceIndex;
   }

   @Override
   public boolean equals(Object object)
   {
      if (object instanceof SliceName)
      {
         SliceName that = (SliceName) object;

         if ((this.sourceName == null && that.sourceName != null)
               || (that.sourceName == null && this.sourceName != null))
         {
            return false;
         }

         if ((this.sourceName == null || this.sourceName.equals(that.sourceName))
               && this.sliceIndex == that.sliceIndex)
         {
            return true;
         }
         else
         {
            return false;
         }
      }
      else
      {
         return false;
      }
   }

   @Override
   public int hashCode()
   {
      // FIXME: This may not return the same value on each invocation if the sliceName or sliceIndex are changed.
      //        In order to make them final, the config framework needs to be modified.
      int hash = 1;
      hash = hash * 31 + this.sourceName.hashCode();
      hash = hash * 31 + this.sliceIndex;
      return hash;
   }

   @Override
   public String toString()
   {
      if (this.sourceName == null)
      {
         return "(Null:" + this.sliceIndex + ")";
      }
      else
      {
         return "(" + this.sourceName.toString() + ":" + this.sliceIndex + ")";
      }
   }
}
