//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: May 1, 2007
//---------------------

package org.cleversafe.layer.grid;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.cleversafe.serialization.GridSerializable;

// TODO: Describe class or interface
public class SourceName implements GridSerializable
{
   private String name = null; // name under which source is known
   private Map<String, String> namedExtensions = null; // Name may be augmented with

   public SourceName()
   {
   }

   public SourceName(String name)
   {
      this.name = name;
   }

   public SourceName(String name, Map<String, String> extensions)
   {
      this.name = name;
      this.namedExtensions = extensions;
   }

   /**
    * 
    * @return
    */
   public String getName()
   {
      return name;
   }

   public void setName(String name)
   {
      this.name = name;
   }

   /**
    * 
    * @return
    */
   public Map<String, String> getNamedExtensions()
   {
      return namedExtensions;
   }

   /**
    * 
    * @param namedExtensions
    */
   public void setNamedExtensions(Map<String, String> namedExtensions)
   {
      this.namedExtensions = namedExtensions;
   }

   /*
    * (non-Javadoc)
    * 
    * @see java.lang.Object#equals(java.lang.Object)
    */
   @Override
   public boolean equals(Object obj)
   {
      if (!(obj instanceof SourceName))
         return false;

      SourceName other = (SourceName) obj;

      if ((this.name == null && other.name != null) || (this.name == null && other.name != null))
         return false;

      if ((this.namedExtensions != null && other.namedExtensions == null)
            || (this.namedExtensions == null && other.namedExtensions != null))
         return false;

      if (this.namedExtensions == null && other.namedExtensions == null)
      {
         if (this.name == null && other.name == null)
         {
            return true;
         }

         if (this.name.equals(other.name))
         {
            return true;
         }
         else
         {
            return false;
         }
      }

      if (this.name != null)
      {
         if (!this.name.equals(other.name))
         {
            return false;
         }
      }
      else
      {
         // both 'name's must be null, because of first 'if' statement
         assert other.name == null;
      }

      // Both 'namedExtensions' are not null and 'name's are same
      Set<String> k1 = this.namedExtensions.keySet();
      Set<String> k2 = other.namedExtensions.keySet();
      if (k1.size() != k2.size())
         return false;
      for (Iterator<String> keyIter = k1.iterator(); keyIter.hasNext();)
      {
         String key = keyIter.next();
         if (!(this.namedExtensions.get(key).equals(other.namedExtensions.get(key))))
         {
            return false;
         }
      }
      return true;
   }

   /*
    * (non-Javadoc)
    * 
    * @see java.lang.Object#toString()
    */
   @Override
   public String toString()
   {
      StringBuffer buf = new StringBuffer();
      buf.append(this.name);
      if (this.namedExtensions != null)
      {
         Set<String> k1 = this.namedExtensions.keySet();
         buf.append("{");
         for (Iterator<String> keyIter = k1.iterator(); keyIter.hasNext();)
         {
            String key = keyIter.next();
            String value = this.namedExtensions.get(key);
            buf.append(",").append(key).append("=").append(value);
         }
         buf.append("}");
      }
      return buf.toString();
   }

   public int hashCode()
   {
      String hashString = this.name;

      if (this.namedExtensions != null)
      {
         hashString += this.namedExtensions.toString();
      }

      return hashString.hashCode();
   }

   /**
    * Convinience method for printiing
    */
   static public String arrayToString(SourceName[] names)
   {
      StringBuffer listOfNames = new StringBuffer();
      for (SourceName name : names)
      {
         listOfNames.append(' ').append(name.toString());
      }
      return listOfNames.toString();
   }
}
