//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Aug 18, 2007
//---------------------

package org.cleversafe.layer.grid;

import java.util.LinkedList;
import java.util.List;


/**
 * Generic implementation of a SourceSliceSet
 */
abstract class SourceSliceSetImpl<T extends DataSlice>
{
   // Source common for all slices in this bundle
   protected SourceName source;

   // Actual slice data
   private List<T> slices;

   /**
    * Construct an empty bundle
    * 
    * @param name
    */
   public SourceSliceSetImpl(SourceName name)
   {
      this.source = name;
      this.slices = new LinkedList<T>();
   }

   /**
    * Construct a bundle from known slices
    * 
    * @param source
    * @param slices
    */
   public SourceSliceSetImpl(SourceName source, List<T> slices)
   {
      this.source = source;

      for (DataSlice slice : slices)
      {
         assert this.verifySource(slice.getSliceName().getSourceName());
      }
      this.slices = slices;
   }

   public SourceName getName()
   {
      return this.source;
   }

   public void addSlice(T slice)
   {
      assert this.verifySource(slice.getSliceName().getSourceName());
      this.slices.add(slice);
   }

   public List<T> getSlices()
   {
      return this.slices;
   }

   protected boolean verifySource(SourceName source)
   {
      return source.equals(this.source);
   }
   
   public int size()
   {
      return this.slices.size();
   }
}


