//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Nov 27, 2007
//---------------------

package org.cleversafe.layer.grid.ranking;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.cleversafe.layer.grid.OperationScorecard;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.Vault;

/**
 * Basic implementation of the sortStores() method which should rarely need to vary.
 */
public abstract class BaseStoreRanking implements StoreRanking
{
   /**
    * Generates a ranking for each of the provided stores and returns an ordered list
    * @see org.cleversafe.layer.grid.ranking.StoreRanking
    */
   public List<SliceStore> sortStores(Vault vault, OperationScorecard scorecard)
   {
      // Compare two stores based on their ranking
      class MyComparator implements Comparator<SliceStore>
      {
         private Map<SliceStore, Float> ratingMap;

         public MyComparator(List<SliceStore> stores, List<Float> ratings)
         {
            assert stores.size() == ratings.size();

            this.ratingMap = new HashMap<SliceStore, Float>();
            for (int i = 0; i < stores.size(); ++i)
            {
               this.ratingMap.put(stores.get(i), ratings.get(i));
            }
         }

         public int compare(SliceStore o1, SliceStore o2)
         {
            Float r1 = this.ratingMap.get(o1);
            Float r2 = this.ratingMap.get(o2);
            assert r1 != null && r2 != null;

            if (r1.equals(r2))
            {
               return 0;
            }
            return (r1 < r2) ? -1 : 1;
         }
      }

      List<SliceStore> storeList = scorecard.getStores();
      List<Float> ratings = this.rateStores(vault, scorecard);
      Collections.sort(storeList, new MyComparator(storeList, ratings));
      return storeList;
   }

   /**
    * Useful helper function for normalizing a list of floats to the interval [0.0, 1.0]
    */
   protected void normalize(List<Float> values)
   {
      Float max = Collections.max(values);
      Float min = Collections.min(values);
      Float range = max - min;
      
      for(int i = 0; i < values.size(); ++i)
      {
         Float value = (values.get(i) - min) / range;
         assert (value >= 0.0) && (value <= 1.0);
         values.set(i, value);
      }
   }
}
