//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 26, 2007
//---------------------

package org.cleversafe.layer.grid.simplecontroller;

import org.apache.log4j.Logger;

import org.cleversafe.layer.grid.ReadController;
import org.cleversafe.layer.grid.ReadControllerFactory;
import org.cleversafe.layer.grid.ThreadedControllerFactoryBase;
import org.cleversafe.layer.grid.exceptions.ControllerException;
import org.cleversafe.layer.grid.simplecontroller.SimpleReadController.Order;
import org.cleversafe.vault.Vault;

public class SimpleReadControllerFactory extends ThreadedControllerFactoryBase
      implements
         ReadControllerFactory
{
   private static Logger _logger = Logger.getLogger(SimpleReadControllerFactory.class);

   private Order order = Order.NORMAL;

   public SimpleReadControllerFactory()
   {
      this(Order.NORMAL);
   }

   public SimpleReadControllerFactory(Order order)
   {
      this.order = order;
   }

   /**
    * @return the order
    */
   public Order getOrder()
   {
      return order;
   }

   /**
    * @param order
    *           the order to set
    */
   public void setOrder(Order order)
   {
      this.order = order;
   }

   public ReadController getInstance(Vault vault)
   {
      return new SimpleReadController(vault, this.order, getExecutor());
   }

   public void release(ReadController rc)
   {
      try
      {
         rc.shutdown();
      }
      catch (ControllerException e)
      {
         _logger.error("Controller exception during shutdown", e);
      }
   }
}
