//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 16, 2007
//---------------------

package org.cleversafe.layer.grid.simplecontroller;

import org.apache.log4j.Logger;
import org.cleversafe.layer.grid.ThreadedControllerFactoryBase;
import org.cleversafe.layer.grid.WriteController;
import org.cleversafe.layer.grid.WriteControllerFactory;
import org.cleversafe.layer.grid.exceptions.ControllerException;
import org.cleversafe.vault.Vault;

// TODO: Describe class or interface
public class SimpleWriteControllerFactory extends ThreadedControllerFactoryBase
      implements
         WriteControllerFactory
{
   private static Logger _logger = Logger.getLogger(SimpleWriteControllerFactory.class);

   private int writeTolearnce = 0;

   public SimpleWriteControllerFactory()
   {
      this(0);
   }

   public SimpleWriteControllerFactory(int writeTolerance)
   {
      this.writeTolearnce = writeTolerance;
   }

   public WriteController getInstance(Vault vault) throws ControllerException
   {
      return new SimpleWriteController(vault, this.writeTolearnce, getExecutor());
   }

   public void release(WriteController wc)
   {
      try
      {
         wc.shutdown();
      }
      catch (ControllerException e)
      {
         _logger.error("Controller exception during shutdown", e);
      }
   }

   /**
    * @return the writeTolearnce
    */
   public int getWriteTolerance()
   {
      return writeTolearnce;
   }

   /**
    * @param writeTolearnce
    *           the writeTolearnce to set
    */
   public void setWriteTolerance(int writeTolearnce)
   {
      this.writeTolearnce = writeTolearnce;
   }
}
