//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: May 8, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "begin_session" response protocol operation (sent from server to client).
 * 
 * The response contains an <code>int</code> session ID of the newly began session.
 * 
 * @see BeginSessionRequest
 * @author Manish Motwani
 */
public class BeginSessionResponse extends GridProtocolResponse
{
   @GridSerializable.ElementOrder(order = 1)
   private int sessionID = -1;

   /**
    * Default constructor.
    * 
    */
   public BeginSessionResponse()
   {
      super(GridProtocolOperation.BEGIN_SESSION_RESPONSE);
   }

   /**
    * Constructor.
    * 
    * @param sessionID
    *           Session ID of the session that has begun.
    */
   public BeginSessionResponse(int sessionID)
   {
      super(GridProtocolOperation.BEGIN_SESSION_RESPONSE);
      this.sessionID = sessionID;
   }

   /**
    * Returns the session ID of the session that has begun.
    * 
    * @return the session ID of the session that has begun.
    */
   public int getSessionID()
   {
      return this.sessionID;
   }

   /**
    * Sets the session ID of the session that has begun.
    * 
    * @param sessionID
    *           the session ID of the session that has begun.
    */
   public void setSessionID(int sessionID)
   {
      this.sessionID = sessionID;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.Response#toString()
    */
   @Override
   public String toString()
   {
      return super.toString() + " Session ID: " + this.sessionID;
   }
}
