//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: May 8, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.serialization.asn1.ASN1ExceptionWrapper;

/**
 * Class for an unsolicited error message from server to client.
 * 
 * The unsolicited message contains an exception thrown by the server to be delivered to the client.
 * 
 * @author Manish Motwani
 */
public class ErrorUnsolicited extends GridProtocolUnsolicitedMessage
{
   @GridSerializable.ElementOrder(order = 1)
   private ASN1ExceptionWrapper exception = null;

   /**
    * Default constructor.
    * 
    */
   public ErrorUnsolicited()
   {
      super(GridProtocolOperation.ERROR_UNSOLICITED);
   }

   /**
    * Constructor.
    * 
    * @param exception
    *           The original exception that was thrown by the server.
    */
   public ErrorUnsolicited(Exception exception)
   {
      super(GridProtocolOperation.ERROR_UNSOLICITED);
      if (exception == null)
      {
         this.exception = null;
      }
      else
      {
         this.exception = new ASN1ExceptionWrapper(exception);
      }
   }

   /**
    * Returns the original exception that was thrown by the server.
    * 
    * @return the original exception that was thrown by the server.
    */
   public Exception getException()
   {
      if (this.exception == null)
      {
         return null;
      }
      else
      {
         return this.exception.getOriginalException();
      }
   }

   /**
    * Sets the exception that was thrown by the server.
    * 
    * @param exception
    *           the exception that was thrown by the server.
    */
   public void setException(Exception exception)
   {
      if (exception == null)
      {
         this.exception = null;
      }
      else if (this.exception == null)
      {
         this.exception = new ASN1ExceptionWrapper(exception);
      }
      else
      {
         this.exception.setOriginalException(exception);
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.UnsolicitedMessage#toString()
    */
   @Override
   public String toString()
   {
      String exceptionText = this.exception == null ? "null" : this.exception.toString();
      return super.toString() + " WrapperNetworkException: " + exceptionText;
   }
}
