//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zach
//
// Date: Sep 11, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Request for a ServerApplication to provide the version numbers of a protocol which the server is
 * compatible.
 * 
 * @author Zachary Mark
 */
public class GetSupportedProtocolVersionsRequest extends GridProtocolRequest
{
   /**
    * The protocol ID for which the client is requesting version compatibility information.
    */
   @GridSerializable.ElementOrder(order = 1)
   private Short protocolID = null;

   /**
    * Default constructor. Does not initialize protocolID.
    */
   public GetSupportedProtocolVersionsRequest()
   {
      super(GridProtocolOperation.GET_PROTOCOL_VERSIONS_REQUEST);
   }

   /**
    * Constructor which initializes the protocolID.
    * 
    * @param protocolID
    *           Protocol ID for which version information is requested.
    */
   public GetSupportedProtocolVersionsRequest(short protocolID)
   {
      super(GridProtocolOperation.GET_PROTOCOL_VERSIONS_REQUEST);
      this.protocolID = protocolID;
   }

   /**
    * Returns the requested protocol ID.
    * 
    * @return The protocol ID, as a byte[].
    */
   public short getProtocolID()
   {
      return this.protocolID;
   }

   /**
    * Set the requested protocol ID.
    * 
    * @param protocolID
    *           The protocol ID.
    */
   public void setProtocolID(short protocolID)
   {
      this.protocolID = protocolID;
   }

}
