//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Manish Motwani
//
// Date: Apr 23, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridProtocolMessageFactory;
import org.cleversafe.serialization.GridSerializable;

/**
 * The base class that all protocol messages inherit from.
 * 
 * @author Manish Motwani
 */
public abstract class GridProtocolMessage
      implements
         VersionedProtocolMessage,
         SequencedProtocolMessage,
         ProtocolSerializable
{

   // This is set at class instantiation and doesn't need to be part of payload.
   @GridSerializable.NotSerializable
   private ProtocolOperation operation;

   @GridSerializable.NotSerializable
   private int sequenceNumber;

   @GridSerializable.NotSerializable
   private short protocolVersion = GridProtocolMessageFactory.GRID_PROTOCOL_VERSION;

   @GridSerializable.NotSerializable
   private short protocolIdentifier = GridProtocolMessageFactory.GRID_PROTOCOL_ID;

   /**
    * Constructor; sets the protocol operation to the input parameter.
    * 
    * @param opType
    *           Operation enumuration value.
    */
   protected GridProtocolMessage(ProtocolOperation operation)
   {
      this.operation = operation;
   }
   
   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.SequencedProtocolMessage#getSequenceNumber()
    */
   public int getSequenceNumber()
   {
      return this.sequenceNumber;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.SequencedProtocolMessage#setSequenceNumber(int)
    */
   public void setSequenceNumber(int sequenceNumber)
   {
      this.sequenceNumber = sequenceNumber;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.ProtocolMessage#getOperation()
    */
   public ProtocolOperation getOperation()
   {
      return this.operation;
   }

   /*
    * (non-Javadoc)
    * 
    * @see java.lang.Object#toString()
    */
   public String toString()
   {
      return this.getClass().getName() + " (Operation Code: " + this.operation.getOperationCode()
            + ", Sequence Number: " + this.sequenceNumber + ")";
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.VersionedProtocolMessage#getProtocolIdentifier()
    */
   public short getProtocolIdentifier()
   {
      return this.protocolIdentifier;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.VersionedProtocolMessage#getProtocolVersion()
    */
   public short getProtocolVersion()
   {
      return this.protocolVersion;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.VersionedProtocolMessage#setProtocolIdentifier()
    */
   public void setProtocolIdentifier(short identifier)
   {
      this.protocolIdentifier = identifier;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.VersionedProtocolMessage#setProtocolVersion()
    */
   public void setProtocolVersion(short version)
   {
      this.protocolVersion = version;
   }
}
