//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 10, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "multiple_remove" response protocol operation (sent from server to client).
 * 
 * The response contains an array of <code>boolean</code>s that indicate whether each of the
 * requested slices were removed.
 * 
 * @see MultipleRemoveRequest
 * @author Manish Motwani
 */
public class MultipleRemoveResponse extends GridProtocolResponse
{
   @GridSerializable.ElementOrder(order = 1)
   private boolean[] removed = null;

   /**
    * Default constructor.
    * 
    */
   public MultipleRemoveResponse()
   {
      super(GridProtocolOperation.MULTIPLE_REMOVE_RESPONSE);
   }

   /**
    * Constructor.
    * 
    */
   public MultipleRemoveResponse(boolean[] removed)
   {
      super(GridProtocolOperation.MULTIPLE_REMOVE_RESPONSE);
      this.removed = removed;
   }

   /**
    * Sets the boolean values that indicate whether the sources were removed.
    * 
    * @param removed
    */
   public void setRemoved(boolean[] removed)
   {
      this.removed = removed;
   }

   /**
    * Returns the boolean array which contains values that indicate whether the sources were
    * removed.
    * 
    * @return boolean array
    */
   public boolean[] getRemoved()
   {
      return this.removed;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.GridProtocolResponse#toString()
    */
   @Override
   public String toString()
   {
      StringBuffer buffer = new StringBuffer();

      buffer.append(super.toString());

      if (this.removed != null)
      {
         buffer.append("[");
         for (int i = 0; i < this.removed.length; ++i)
         {
            buffer.append(Boolean.toString(this.removed[i]));
            if (i != this.removed.length - 1)
            {
               buffer.append(", ");
            }
         }
         buffer.append("]");
      }

      return buffer.toString();
   }
}
