//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Apr 30, 2007
//---------------------

package org.cleversafe.layer.protocol;

import org.cleversafe.serialization.GridSerializable;

/**
 * Class for "noop" request protocol operation (sent from client to server).
 * 
 * The request contains a <code>String</code> message and a <code>byte</code> array as the
 * payload.
 * 
 * @see NoopResponse
 * @author Manish Motwani
 */
public class NoopRequest extends GridProtocolRequest
{
   @GridSerializable.ElementOrder(order = 1)
   private String _message = "Hello, server!";

   @GridSerializable.ElementOrder(order = 2)
   private byte[] _payload = new byte[0];

   /**
    * Default constructor.
    * 
    */
   public NoopRequest()
   {
      super(GridProtocolOperation.NOOP_REQUEST);
   }

   /**
    * Sets the payload data <code>byte</code> array.
    * 
    * @param data
    */
   public void setPayload(byte[] data)
   {
      this._payload = data;
   }

   /**
    * Returns the payload data <code>byte</code> array.
    * 
    * @return the payload data <code>byte</code> array.
    */
   public byte[] getPayload()
   {
      return this._payload;
   }

   /**
    * Sets the payload <code>String</code> message.
    * 
    * @param message
    */
   public void setMessage(String message)
   {
      this._message = message;
   }

   /**
    * Returns the payload <code>String</code> message.
    * 
    * @return the payload <code>String</code> message.
    */
   public String getMessage()
   {
      return this._message;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.protocol.messages.Request#toString()
    */
   @Override
   public String toString()
   {
      if (this._message != null)
      {
         return super.toString() + " message: " + this._message;
      }
      else
      {
         return super.toString() + " null message";
      }
   }
}
