//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zach
//
// Date: Sep 10, 2007
//---------------------

package org.cleversafe.layer.protocol;

/**
 * Interface to indicate that a protocol message has versioning information.
 */
public interface VersionedProtocolMessage
{
   /**
    * Get the protocol version of the message.
    * 
    * @return The protocol version of the message, as an short.
    */
   public short getProtocolVersion();
   
   /**
    * Get the protocol identifier which identifies the protocol to which this message belongs.
    * 
    * @return The identifier encoded as a byte array.
    */
   public short getProtocolIdentifier();
   
   /**
    * Get the protocol version of the message.
    * 
    * @param The protocol version of the message, as an short.
    */   
   public void setProtocolVersion( short version );
   
   /**
    * Set the protocol identifier which identifies the protocol to which this message belongs.
    * 
    * @param The identifier encoded as a byte array.
    */
   public void setProtocolIdentifier( short identifier );
}


