//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 3, 2007
//---------------------

package org.cleversafe.layer.slicestore;

import java.util.HashMap;
import java.util.Map;

/**
 * This abstract class is used to specify the necessary properties needed for constructing
 * individual implementations of SliceStore.
 */
public abstract class SliceStoreInfo
{
   public static final String DEFAULT_SLICE_STORE_TYPE = "default";

   private String sliceStoreType = DEFAULT_SLICE_STORE_TYPE;
   private Map<String, String> properties = null;

   /**
    * Default Constructor
    */
   protected SliceStoreInfo()
   {
      this.properties = new HashMap<String, String>();
   }

   /**
    * Constructs a SliceStoreInfo specifying the slice store type, such as
    * "block-file", "bdb", etc.
    * 
    * @param sliceStoreType
    */
   protected SliceStoreInfo(String sliceStoreType)
   {
      this();
      this.sliceStoreType = sliceStoreType;
   }

   /**
    * Setter for the sliceStoreType member variable
    * 
    * @param sliceStoreType
    */
   public void setSliceStoreType(String sliceStoreType)
   {
      this.sliceStoreType = sliceStoreType;
   }

   /**
    * Getter for the sliceStoreType member variable
    * 
    * @return sliceStoreType
    */
   public String getSliceStoreType()
   {
      return this.sliceStoreType;
   }

   /**
    * Sets a property in the properties map for this object
    * 
    * @param key
    * @param value
    */
   public void setProperty(String key, String value)
   {
      if (properties.containsKey(key))
      {
         throw new IllegalArgumentException("Property already exists: " + key);
      }

      this.properties.put(key, value);
   }

   /**
    * Returns a property contained in this object's propery map
    * 
    * @param key
    * @return value
    */
   public String getProperty(String key)
   {
      return this.properties.get(key);
   }

   /**
    * Returns a reference to the properties map
    * 
    * @return properties
    */
   public Map<String, String> getProperties()
   {
      return this.properties;
   }
}
