//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Apr 26, 2007
//---------------------

package org.cleversafe.layer.slicestore;

/**
 * This is a marker interface. An implementation only has to implement equality
 * RemoteStore implementation would implement equality based on 'long' id assigned to
 * each remote transaction
 */
public interface SliceStoreTransaction
{  
   /**
    * Returns the long id for this transaction object
    * 
    * @return transactionId
    */
   long getID();
   
   /**
    * Returns reference to the slice store that this transaction belongs to
    * 
    * @return sliceStore
    */
   SliceStore getSliceStore();
}


