//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Jan 28, 2008
//---------------------

package org.cleversafe.layer.slicestore.memory;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.cleversafe.layer.grid.DataSlice;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.layer.slicestore.SliceStoreTransaction;

// TODO: Describe class or interface
class MemorySliceStoreTransaction implements SliceStoreTransaction
{
   private final long id;
   private final SliceStore sliceStore;
   private boolean active;

   Set<DataSlice> unwrittenSlices = Collections.synchronizedSet(new HashSet<DataSlice>());

   public MemorySliceStoreTransaction(final long id, final SliceStore sliceStore)
   {
      if (!(sliceStore instanceof MemorySliceStore))
      {
         throw new IllegalArgumentException(
               "The SliceStore in MemorySliceStoreTransaction must be a MemorySliceStore");
      }

      this.id = id;
      this.sliceStore = sliceStore;
   }

   public long getID()
   {
      return this.id;
   }

   public SliceStore getSliceStore()
   {
      return this.sliceStore;
   }

   public boolean isActive()
   {
      return this.active;
   }

   public void begin()
   {
      this.active = true;
   }

   public void commit()
   {
      this.active = false;
      this.unwrittenSlices.clear();
   }

   public void rollback()
   {
      this.unwrittenSlices.clear();
   }

   public void write(final DataSlice slice)
   {
      this.unwrittenSlices.add(slice);
   }

   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + (int) (this.id ^ (this.id >>> 32));
      return result;
   }

   @Override
   public boolean equals(final Object obj)
   {
      if (this == obj)
      {
         return true;
      }
      if (obj == null)
      {
         return false;
      }
      if (getClass() != obj.getClass())
      {
         return false;
      }
      final MemorySliceStoreTransaction other = (MemorySliceStoreTransaction) obj;
      if (this.id != other.id)
      {
         return false;
      }
      return true;
   }
}
