//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Jul 24, 2007
//---------------------

package org.cleversafe.policy.exceptions;

import java.util.UUID;


/**
 * Exception is thrown when access policy 
 */
public class AccessException extends PolicyException
{
   private static final long serialVersionUID = 4299374093702561915L;
   /**
    * Vaultid for which exception was thrown
    */
   private UUID vaultId;
   /**
    * 
    * @param vaultId
    * @param message
    */
   public AccessException (UUID vaultId, String message)
   {
      super(message);
      this.vaultId = vaultId;
   }
   
   /**
    * 
    * @param vaultId
    * @param message
    * @param cause
    */
   public AccessException (UUID vaultId, String message, Throwable cause)
   {
      super(message, cause);
      this.vaultId = vaultId;
   }
   /**
    * 
    * @param vaultId
    * @param cause
    */
   public AccessException (UUID vaultId, Throwable cause)
   {
      super(cause);
      this.vaultId = vaultId;
   }
   public String toString() 
   {
      return "Access to vault:" + vaultId + " denied:" + super.getMessage();
   }
}


