//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: abaptist
//
// Date: Oct 4, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import java.io.DataInputStream;
import java.io.DataOutputStream;

import org.apache.log4j.Logger;
import org.cleversafe.layer.protocol.GridProtocolMessage;
import org.cleversafe.layer.protocol.ProtocolMessage;
import org.cleversafe.layer.protocol.exceptions.OperationNotRegisteredException;
import org.cleversafe.layer.protocol.exceptions.ProtocolDeserializationException;
import org.cleversafe.layer.protocol.exceptions.ProtocolSerializationException;
import org.cleversafe.serialization.GridProtocolMessageFactory;

public class ASN1GridProtocolMessageFactory extends GridProtocolMessageFactory
{
   private static Logger _logger = Logger.getLogger(ASN1GridProtocolMessageFactory.class);

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.ProtocolMessageFactory#deserialize(byte[])
    */
   public ProtocolMessage deserialize(int operationCode, DataInputStream payload)
         throws OperationNotRegisteredException, ProtocolDeserializationException
   {
      assert payload != null;

      // Get the class type to create.
      Class<?> operationClass = getMessageType(operationCode);

      if (_logger.isTraceEnabled())
      {
         _logger.trace("Deserializing protocol message: " + operationClass.getName());
      }

      // Creating the class from the serialized message
      GridProtocolMessage pm = null;
      try
      {
         pm = (GridProtocolMessage) operationClass.newInstance();

         byte[] payloadData = new byte[payload.available()];
         payload.read(payloadData);

         ASN1.DERConverter.decode(pm, payloadData);
      }
      catch (Exception e)
      {
         throw new ProtocolDeserializationException("ASN.1 decoding failed", e);
      }

      return pm;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.ProtocolMessageFactory#serialize(org.cleversafe.layer.communication.protocol.ProtocolMessage)
    */
   public void serialize(DataOutputStream out, ProtocolMessage pm)
         throws ProtocolSerializationException
   {
      assert pm != null;
      assert (pm instanceof GridProtocolMessage) : "Protocol message was not an instance of GridProtocolMessage";

      if (_logger.isTraceEnabled())
      {
         _logger.trace("Serializing protocol message: " + pm.getClass().getName());
      }

      try
      {
         out.write(ASN1.DERConverter.encode(pm));
      }
      catch (Exception e)
      {
         throw new ProtocolSerializationException("ASN.1 encoding failed!", e);
      }
   }

   public Class<?> getDecoderClass()
   {
      return ASN1ProtocolMessageDecoder.class;
   }

   public Class<?> getEncoderClass()
   {
      return ASN1ProtocolMessageEncoder.class;
   }

   public int getMaxSerializedSize(ProtocolMessage message)
   {
      // Note this size does not have to be exact, as the output
      // stream will grow as needed. Here we use the default allocation
      // size for ByteArrayOutputStream
      return 32;
   }
}
