//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Jul 19, 2007
//---------------------

package org.cleversafe.serialization.asn1;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.cleversafe.layer.protocol.GridProtocolOperation;
import org.cleversafe.layer.protocol.ProtocolOperation;
import org.cleversafe.layer.protocol.exceptions.OperationAlreadyRegisteredException;
import org.cleversafe.layer.protocol.exceptions.OperationException;
import org.cleversafe.layer.protocol.exceptions.OperationNotDefinedException;
import org.cleversafe.layer.protocol.exceptions.OperationNotRegisteredException;
import org.cleversafe.layer.slicestore.exceptions.UnsupportedSliceStoreTypeException;
import org.cleversafe.layer.slicestore.exceptions.UnsupportedVaultTypeException;
import org.cleversafe.server.exceptions.IllegalSessionStateException;
import org.cleversafe.server.exceptions.ServerRequestException;
import org.cleversafe.server.exceptions.UnauthorizedRequestException;
import org.cleversafe.server.exceptions.UnrecognizedRequestException;

// TODO: Describe class or interface
public class ExceptionCoder
{
   // Operation exception
   public static DERInteger encodeOperationException(final OperationException exception)
   {
      return new DERInteger(exception.getOperation().getOperationCode());
   }

   public static void decodeOperationException(
         final OperationException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      assert asnObj instanceof DERInteger;
      DERInteger integer = (DERInteger) asnObj;
      int operationCode = integer.getValue().intValue();
      ProtocolOperation operation = GridProtocolOperation.fromOperationCode(operationCode);
      exception.setOperation(operation);
   }

   // Request exception
   public static DERInteger encodeRequestException(final ServerRequestException exception)
   {
      return new DERInteger(exception.getOperation().getOperationCode());
   }

   public static void decodeRequestException(
         final ServerRequestException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      assert asnObj instanceof DERInteger;
      DERInteger integer = (DERInteger) asnObj;
      int operationCode = integer.getValue().intValue();
      ProtocolOperation operation = GridProtocolOperation.fromOperationCode(operationCode);
      exception.setOperation(operation);
   }

   // OperationAlreadyRegisteredException
   public static DERInteger encodeOperationException(
         final OperationAlreadyRegisteredException exception)
   {
      return encodeOperationException((OperationException) exception);
   }

   public static void decodeOperationException(
         final OperationAlreadyRegisteredException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      decodeOperationException((OperationException) exception, asnObj);
   }

   // OperationNotRegisteredException
   public static DERInteger encodeOperationException(final OperationNotRegisteredException exception)
   {
      return encodeOperationException((OperationException) exception);
   }

   public static void decodeOperationException(
         final OperationNotRegisteredException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      decodeOperationException((OperationException) exception, asnObj);
   }

   // UnauthorizedRequestException
   public static DERInteger encodeRequestException(final UnauthorizedRequestException exception)
   {
      return encodeRequestException((ServerRequestException) exception);
   }

   public static void decodeRequestException(
         final UnauthorizedRequestException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      decodeRequestException((ServerRequestException) exception, asnObj);
   }

   // UnrecognizedRequestException
   public static DERInteger encodeRequestException(final UnrecognizedRequestException exception)
   {
      return encodeRequestException((ServerRequestException) exception);
   }

   public static void decodeRequestException(
         final UnrecognizedRequestException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      decodeRequestException((ServerRequestException) exception, asnObj);
   }

   // IllegalSessionStateException
   public static DERInteger encodeRequestException(final IllegalSessionStateException exception)
   {
      return encodeRequestException((ServerRequestException) exception);
   }

   public static void decodeRequestException(
         final IllegalSessionStateException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      decodeRequestException((ServerRequestException) exception, asnObj);
   }

   // OperationNotDefinedException
   public static DERInteger encodeOperationNotDefinedException(
         final OperationNotDefinedException exception)
   {
      return new DERInteger(exception.getOperationCode());
   }

   public static void decodeOperationNotDefinedException(
         final OperationNotDefinedException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      assert asnObj instanceof DERInteger;
      DERInteger integer = (DERInteger) asnObj;
      int operationCode = integer.getValue().intValue();
      exception.setOperationCode(operationCode);
   }

   // UnsupportedSliceStoreTypeException
   public static DERSequence encodeUnsupportedSliceStoreTypeException(
         final UnsupportedSliceStoreTypeException exception)
   {
      DERGeneralString vaultType = new DERGeneralString(exception.getVaultType());
      DERGeneralString sliceStoreType = new DERGeneralString(exception.getSliceStoreType());
      DERSequence seq = new DERSequence(new DERObject[]{
            vaultType, sliceStoreType
      });
      return seq;
   }

   public static void decodeUnsupportedSliceStoreTypeException(
         final UnsupportedSliceStoreTypeException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      assert asnObj instanceof DERSequence;
      DERSequence seq = (DERSequence) asnObj;

      DEREncodable obj1 = seq.getObjectAt(0);
      DEREncodable obj2 = seq.getObjectAt(1);

      assert obj1 instanceof DERGeneralString;
      assert obj2 instanceof DERGeneralString;

      exception.setVaultType(((DERGeneralString) obj1).getString());
      exception.setSliceStoreType(((DERGeneralString) obj2).getString());
   }

   // UnsupportedVaultTypeException
   public static DERSequence encodeUnsupportedVaultTypeException(
         final UnsupportedVaultTypeException exception)
   {
      DERGeneralString vaultType = new DERGeneralString(exception.getVaultType());
      DERSequence seq = new DERSequence(new DERObject[]{
         vaultType
      });
      return seq;
   }

   public static void decodeUnsupportedVaultTypeException(
         final UnsupportedVaultTypeException exception,
         final ASN1Object asnObj) throws OperationNotDefinedException
   {
      assert asnObj instanceof DERSequence;
      DERSequence seq = (DERSequence) asnObj;

      DEREncodable obj1 = seq.getObjectAt(0);

      assert obj1 instanceof DERGeneralString;

      exception.setVaultType(((DERGeneralString) obj1).getString());
   }

}
