//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 14, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import java.lang.reflect.Method;

/**
 * This is the interface that all custom ASN.1 serialization classes must implement.
 * <p>
 * In addition to the listed methods in this interface, these classes should also have a default
 * constructor as well as <code>encode</code> and <code>decode</code> methods for the
 * serializable class.
 * 
 * @author Manish Motwani
 */
public interface CustomSerialization
{
   /**
    * Returns the serializable <code>Class</code> for which this custom serialization provides
    * custom <code>encode</code> and <code>decode</code> method.
    * 
    * @return
    */
   Class<?> getSerializableClass();

   /**
    * Returns the <code>Method</code> that implements custom encoding for the said serializable
    * class. The only parameter for this method must be an object of the serializable class to be
    * encoded. The return value must be an <code>ASN1Object</code>.
    * 
    * @return
    */
   Method getEncodeMethod();

   /**
    * Returns the <code>Method</code> that implements custom decoding for the said serializable
    * class. The parameters for this method must be an object of the serializable class to be
    * decoded and an <code>ASN1Object</code> to decode from.
    * 
    * @return
    */
   Method getDecodeMethod();
}
