//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: vthornton
//
// Date: Aug 21, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.cleversafe.layer.protocol.ListContinueResponse;
import org.cleversafe.layer.slicestore.SliceInfo;
import org.cleversafe.serialization.asn1.ASN1ExceptionWrapper;

/**
 * Implements custom ASN.1 <code>encode</code> and <code>decode</code> methods for
 * {@link ListContinueResponse}.
 * 
 * @see ListContinueResponse
 * @author Vance Thornton
 */
public class ListContinueResponseSerialization implements CustomSerialization
{
   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.serialization.asn1.custom.CustomSerialization#getSerializableClass()
    */
   public Class<ListContinueResponse> getSerializableClass()
   {
      return ListContinueResponse.class;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.serialization.asn1.custom.CustomSerialization#getEncodeMethod()
    */
   public Method getEncodeMethod()
   {
      try
      {
         return ListContinueResponseSerialization.class.getMethod("encodeListContinueResponse",
               new Class[]{
                  getSerializableClass()
               });
      }
      catch (NoSuchMethodException nsme)
      {
         throw new RuntimeException("Error in code above.", nsme);
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.serialization.asn1.custom.CustomSerialization#getDecodeMethod()
    */
   public Method getDecodeMethod()
   {
      try
      {
         return ListContinueResponseSerialization.class.getMethod("decodeListContinueResponse",
               new Class[]{
                     getSerializableClass(), ASN1Object.class
               });
      }
      catch (NoSuchMethodException nsme)
      {
         throw new RuntimeException("Error in code above.", nsme);
      }
   }

   /**
    * Encode method for {@link ListContinueResponse}.
    * 
    * @param listContinueResponse
    * @return
    */
   public static DERSequence encodeListContinueResponse(ListContinueResponse listContinueResponse)
   {
      DERObject exception = null;
      Exception e = listContinueResponse.getException();
      if (e == null)
      {
         exception = new DERNull();
      }
      else
      {
         exception = ASN1ExceptionWrapper.encodeSingleException(e);
      }

      List<SliceInfo> slices = listContinueResponse.getSlices();

      if (slices == null)
      {
         return new DERSequence(new DERObject[]{
               exception, new DERNull()
         });
      }

      ASN1Encodable[] sliceInfoArray = new ASN1Encodable[slices.size()];
      for (int i = 0; i < slices.size(); i++)
      {
         sliceInfoArray[i] = SliceInfoSerialization.encodeSliceInfo(slices.get(i));
      }

      return new DERSequence(new DERObject[]{
            exception, new DERSequence(sliceInfoArray)
      });
   }

   /**
    * Decode method for {@link ListContinueResponse}.
    * 
    * @param listContinueResponse
    * @param asnObj
    */
   public static void decodeListContinueResponse(
         ListContinueResponse listContinueResponse,
         ASN1Object asnObj)
   {
      assert asnObj instanceof DERSequence;
      DERSequence derListContinueResponse = (DERSequence) asnObj;

      assert derListContinueResponse.size() == 2;

      if (derListContinueResponse.getObjectAt(0) instanceof DERNull)
      {
         listContinueResponse.setException(null);
      }
      else
      {
         assert derListContinueResponse.getObjectAt(0) instanceof DERSequence;
         Exception e =
               ASN1ExceptionWrapper.decodeSingleException((DERSequence) derListContinueResponse.getObjectAt(0));
         listContinueResponse.setException(e);
      }

      if (derListContinueResponse.getObjectAt(1) instanceof DERNull)
      {
         listContinueResponse.setSlices(null);
      }
      else
      {
         assert derListContinueResponse.getObjectAt(1) instanceof DERSequence;

         DERSequence derSlices = (DERSequence) derListContinueResponse.getObjectAt(1);
         if (derSlices.size() == 0)
         {
            listContinueResponse.setSlices(new ArrayList<SliceInfo>());
         }
         else
         {
            List<SliceInfo> slices = new ArrayList<SliceInfo>();

            for (int i = 0; i < derSlices.size(); i++)
            {
               assert derSlices.getObjectAt(i) instanceof DERSequence;
               SliceInfo slice = new SliceInfo();
               SliceInfoSerialization.decodeSliceInfo(slice, (DERSequence) derSlices.getObjectAt(i));

               slices.add(slice);
            }
            listContinueResponse.setSlices(slices);
         }
      }

   }

}
