//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 14, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import org.cleversafe.serialization.asn1.ASN1;

/**
 * Registers custom ASN.1 serialization classes in this package with {@link ASN1.DERConverter}.
 * <p>
 * These custom ASN.1 serialization classes must implement the CustomSerialization interface and
 * have custom <code>static encode</code> and <code>decode</code> methods for the serializable
 * class.
 * 
 * @author Manish Motwani
 */
public class Registrator
{
   private static boolean registered = false;

   /**
    * Registers custom ASN.1 serialization classes in this package with {@link ASN1.DERConverter}.
    */
   public static void registorCustomObjects()
   {
      if (!registered)
      {
         // TODO: Can reflection be used to find all classes that implement CustomSerialization and
         // register them?
         registerCustomObject(new SourceNameSerialization());
         registerCustomObject(new SliceNameSerialization());
         registerCustomObject(new DataSliceSerialization());
         registerCustomObject(new SliceInfoSerialization());

         // Custom encoding for frequently used protocol message
         registerCustomObject(new MultipleReadRequestSerialization());
         registerCustomObject(new MultipleReadResponseSerialization());
         registerCustomObject(new MultipleWriteRequestSerialization());
         registerCustomObject(new MultipleWriteResponseSerialization());
         registerCustomObject(new BeginTransactionRequestSerialization());
         registerCustomObject(new BeginTransactionResponseSerialization());
         registerCustomObject(new CommitTransactionRequestSerialization());
         registerCustomObject(new CommitTransactionResponseSerialization());
         registerCustomObject(new ListContinueResponseSerialization());
         registerCustomObject(new NoopRequestSerialization());
         registerCustomObject(new NoopResponseSerialization());

         registered = true;
      }
   }

   private static void registerCustomObject(CustomSerialization serialization)
   {
      ASN1.DERConverter.registerDefaultEncodeDecode(serialization.getSerializableClass(),
            serialization.getEncodeMethod(), serialization.getDecodeMethod());
   }

   public static void main(String[] args)
   {
      registorCustomObjects();
   }

   /**
    * Returns <code>true</code> if custom serialization classes in the package have been
    * registered with {@link ASN1.DERConverter}; <code>false</code> otherwise.
    * 
    * @return
    */
   public static boolean getRegistered()
   {
      return registered;
   }
}
