//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Aug 16, 2007
//---------------------

package org.cleversafe.serialization.asn1.custom;

import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERNull;
import org.cleversafe.exceptions.BaseException;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.serialization.asn1.ASN1ExceptionWrapper;

/**
 * Utility serialization class to <code>encode</code> and <code>decode</code> serializable
 * exception objects contained in protocol responses.
 * <p>
 * {@link ASN1ExceptionWrapper} is used to <code>encode</code> and <code>decode</code> exception
 * objects that are serializable as defined part of the protocol.
 * 
 * @see Response
 * @see BaseException
 * @author Manish Motwani
 */
public class ResponseExceptionSerializationUtil
{
   /**
    * Encodes the exception in the input {@link Response} object.
    * 
    * @see ASN1ExceptionWrapper
    * @param response
    * @return
    */
   public static ASN1Object encodeResponseException(Response response)
   {
      ASN1Object exception = null;
      Exception e = response.getException();
      if (e == null)
      {
         exception = new DERNull();
      }
      else
      {
         exception = ASN1ExceptionWrapper.encodeSingleException(e);
      }

      return exception;
   }

   /**
    * Decodes <code>asnObj</code> into an exception and sets it in the input {@link Response}
    * object.
    * 
    * @see ASN1ExceptionWrapper
    * @param response
    * @param asnObj
    */
   public static void decodeResponseException(Response response, ASN1Object asnObj)
   {
      if (asnObj instanceof DERNull)
      {
         response.setException(null);
      }
      else
      {
         Exception e = ASN1ExceptionWrapper.decodeSingleException(asnObj);
         response.setException(e);
      }
   }

}
