//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: abaptist
//
// Date: Oct 4, 2007
//---------------------

package org.cleversafe.serialization.raw;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import org.apache.log4j.Logger;
import org.cleversafe.layer.protocol.GridProtocolMessage;
import org.cleversafe.layer.protocol.ProtocolMessage;
import org.cleversafe.layer.protocol.exceptions.OperationNotRegisteredException;
import org.cleversafe.layer.protocol.exceptions.ProtocolDeserializationException;
import org.cleversafe.layer.protocol.exceptions.ProtocolSerializationException;
import org.cleversafe.serialization.GridProtocolMessageFactory;
import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.serialization.exceptions.EncodeDecodeException;
import org.cleversafe.serialization.raw.custom.CustomRawSerialization;
import org.cleversafe.serialization.raw.custom.CustomRawSerializationRegistrator;

public class RawGridProtocolMessageFactory extends GridProtocolMessageFactory
{
   private static Logger _logger = Logger.getLogger(RawGridProtocolMessageFactory.class);

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.ProtocolMessageFactory#deserialize(byte[])
    */
   public ProtocolMessage deserialize(int operationCode, DataInputStream payload)
         throws OperationNotRegisteredException, ProtocolDeserializationException
   {
      assert payload != null;

      // Get the class type to create.
      Class<? extends GridSerializable> operationClass = getMessageType(operationCode);

      if (_logger.isTraceEnabled())
      {
         _logger.trace("Deserializing protocol message: " + operationClass.getName());
      }

      // Creating the class from the serialized message
      GridProtocolMessage pm = null;
      try
      {
         try
         {
            CustomRawSerialization crs =
                  CustomRawSerializationRegistrator.getCustomSerialization(operationClass);
            pm = (GridProtocolMessage) crs.read(payload);
         }
         catch (IOException e)
         {
            throw new EncodeDecodeException("Error while decoding " + operationClass.getName(), e);
         }
      }
      catch (Exception e)
      {
         throw new ProtocolDeserializationException("Raw decoding failed", e);
      }

      return pm;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.communication.protocol.ProtocolMessageFactory#serialize(org.cleversafe.layer.communication.protocol.ProtocolMessage)
    */
   public void serialize(DataOutputStream out, ProtocolMessage pm)
         throws ProtocolSerializationException
   {
      assert pm != null;
      assert (pm instanceof GridProtocolMessage) : "Protocol message was not an instance of GridProtocolMessage";

      if (_logger.isTraceEnabled())
      {
         _logger.trace("Serializing protocol message: " + pm.getClass().getName());
      }

      try
      {
         CustomRawSerializationRegistrator.getCustomSerialization(pm.getClass()).write(out, pm);
      }
      catch (Exception e)
      {
         throw new ProtocolSerializationException("Raw encoding failed!", e);
      }
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.ProtocolMessageFactory#getDecoderClass()
    */
   public Class<?> getDecoderClass()
   {
      return RawProtocolMessageDecoder.class;
   }

   /*
    * (non-Javadoc)
    * 
    * @see org.cleversafe.layer.protocol.ProtocolMessageFactory#getEncoderClass()
    */
   public Class<?> getEncoderClass()
   {
      return RawProtocolMessageEncoder.class;
   }

   public int getMaxSerializedSize(ProtocolMessage pm)
   {
      assert pm != null;
      assert (pm instanceof GridProtocolMessage) : "Protocol message was not an instance of GridProtocolMessage";

      return CustomRawSerializationRegistrator.getCustomSerialization(pm.getClass()).getMaxSerializedSize(
            pm);
   }
}
