//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Oct 4, 2007
//---------------------

package org.cleversafe.serialization.raw.custom;

import java.util.HashMap;
import java.util.Map;

import org.cleversafe.layer.protocol.BeginSessionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.CommitTransactionResponse;
import org.cleversafe.layer.protocol.CreateStoreResponse;
import org.cleversafe.layer.protocol.EndSessionResponse;
import org.cleversafe.layer.protocol.ErrorResponse;
import org.cleversafe.layer.protocol.GetSupportedProtocolsRequest;
import org.cleversafe.layer.protocol.ListBeginRequest;
import org.cleversafe.layer.protocol.ListBeginResponse;
import org.cleversafe.layer.protocol.ListContinueRequest;
import org.cleversafe.layer.protocol.ListInProgressRequest;
import org.cleversafe.layer.protocol.ListStopRequest;
import org.cleversafe.layer.protocol.ListStopResponse;
import org.cleversafe.layer.protocol.MultipleWriteResponse;
import org.cleversafe.layer.protocol.RegisterForNotificationsResponse;
import org.cleversafe.layer.protocol.RemoveStoreResponse;
import org.cleversafe.layer.protocol.RollbackTransactionResponse;
import org.cleversafe.layer.protocol.VaultBindResponse;
import org.cleversafe.serialization.GridSerializable;

public class CustomRawSerializationRegistrator
{
   private static Map<Class<? extends GridSerializable>, CustomRawSerialization> serializationMap =
         new HashMap<Class<? extends GridSerializable>, CustomRawSerialization>();

   // Hard-coded Registration
   static
   {
      // Noop
      register(new NoopRequestSerialization());
      register(new NoopResponseSerialization());

      // Multiple read/write/remove
      register(new MultipleReadRequestSerialization());
      register(new MultipleReadResponseSerialization());
      register(new MultipleWriteRequestSerialization());
      register(MultipleWriteResponse.class, new BaseResponseSerialization(
            MultipleWriteResponse.class));
      register(new MultipleRemoveRequestSerialization());
      register(new MultipleRemoveResponseSerialization());

      // Password authentication
      register(new PasswordAuthenticationRequestSerialization());
      register(new PasswordAuthenticationResponseSerialization());

      // Session
      register(BeginSessionRequest.class, new BaseRequestSerialization(BeginSessionRequest.class));
      register(new BeginSessionResponseSerialization());
      register(new EndSessionRequestSerialization());
      register(EndSessionResponse.class, new BaseResponseSerialization(EndSessionResponse.class));

      // Transaction
      register(new BeginTransactionRequestSerialization());
      register(BeginTransactionResponse.class, new BaseResponseSerialization(
            BeginTransactionResponse.class));
      register(new CommitTransactionRequestSerialization());
      register(CommitTransactionResponse.class, new BaseResponseSerialization(
            CommitTransactionResponse.class));
      register(new RollbackTransactionRequestSerialization());
      register(RollbackTransactionResponse.class, new BaseResponseSerialization(
            RollbackTransactionResponse.class));

      // Store
      register(new CreateStoreRequestSerialization());
      register(CreateStoreResponse.class, new BaseResponseSerialization(CreateStoreResponse.class));
      register(new RemoveStoreRequestSerialization());
      register(RemoveStoreResponse.class, new BaseResponseSerialization(RemoveStoreResponse.class));

      // Vault
      register(new VaultBindRequestSerialization());
      register(VaultBindResponse.class, new BaseResponseSerialization(VaultBindResponse.class));

      // Protocol queries
      register(GetSupportedProtocolsRequest.class, new BaseRequestSerialization(
            GetSupportedProtocolsRequest.class));
      register(new GetSupportedProtocolsResponseSerialization());
      register(new GetSupportedProtocolVersionsRequestSerialization());
      register(new GetSupportedProtocolVersionsResponseSerialization());

      // Integrity
      register(new IntegrityVerificationRequestSerialization());
      register(new IntegrityVerificationResponseSerialization());

      // Listing
      register(new ExistsRequestSerialization());
      register(new ExistsResponseSerialization());
      register(ListContinueRequest.class, new BaseRequestSerialization(ListContinueRequest.class));
      register(new ListContinueResponseSerialization());
      register(ListInProgressRequest.class, new BaseRequestSerialization(
            ListInProgressRequest.class));
      register(new ListInProgressResponseSerialization());
      register(ListBeginRequest.class, new BaseRequestSerialization(ListBeginRequest.class));
      register(ListBeginResponse.class, new BaseResponseSerialization(ListBeginResponse.class));
      register(ListStopRequest.class, new BaseRequestSerialization(ListStopRequest.class));
      register(ListStopResponse.class, new BaseResponseSerialization(ListStopResponse.class));

      // Notifications
      register(new RegisterForNotificationsRequestSerialization());
      register(RegisterForNotificationsResponse.class, new BaseResponseSerialization(
            RegisterForNotificationsResponse.class));
      register(new WriteNotifyUnsolicitedSerialization());

      // Errors
      register(ErrorResponse.class, new BaseResponseSerialization(ErrorResponse.class));
      register(new ErrorUnsolicitedSerialization());

      // Serializable data types
      register(new DataSliceSerialization());
      register(new SourceNameSerialization());
      register(new SliceNameSerialization());
      register(new SliceInfoSerialization());
   }

   public static CustomRawSerialization getCustomSerialization(
         Class<? extends GridSerializable> serializable)
   {
      if (serializationMap.containsKey(serializable))
      {
         return serializationMap.get(serializable);
      }
      else
      {
         throw new RuntimeException("Custom raw serialization not found for class "
               + serializable.getName());
      }
   }

   public static void register(CustomRawSerialization serialization)
   {
      register(serialization.getSerializableClass(), serialization);
   }

   private static void register(
         Class<? extends GridSerializable> cls,
         CustomRawSerialization serialization)
   {
      serializationMap.put(cls, serialization);
   }
}
