//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Oct 4, 2007
//---------------------

package org.cleversafe.serialization.raw.custom;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

import org.cleversafe.layer.grid.SourceName;
import org.cleversafe.serialization.GridSerializable;
import org.cleversafe.serialization.exceptions.EncodeDecodeException;

// FIXME: SourceName's named extensions are currently not being serialized
public class SourceNameSerialization extends CustomRawSerializationBase
{
   public SourceNameSerialization()
   {
      super(SourceName.class);
   }

   @Override
   public GridSerializable read(DataInput in) throws EncodeDecodeException, IOException
   {
      SourceName sourceName = new SourceName();

      // Read the string name
      sourceName.setName(readString(in));

      // If named extensions exist, read them
      if (in.readBoolean())
      {
         sourceName.setNamedExtensions(readStringMap(in));
      }

      return sourceName;
   }

   @Override
   public void write(DataOutput out, GridSerializable serializable) throws EncodeDecodeException,
         IOException
   {
      assert serializable instanceof SourceName;
      SourceName sourceName = (SourceName) serializable;

      if (sourceName.getName() == null)
      {
         throw new EncodeDecodeException("SourceName's name field must not be null");
      }

      // Write the string name
      writeString(out, sourceName.getName());

      // If named extensions exist, write them
      if (sourceName.getNamedExtensions() == null)
      {
         out.writeBoolean(false);
      }
      else
      {
         out.writeBoolean(true);
         writeStringMap(out, sourceName.getNamedExtensions());
      }
   }

   @Override
   public int getMaxSerializedSize(GridSerializable serializable)
   {
      assert serializable instanceof SourceName;
      SourceName sourceName = (SourceName) serializable;

      int size = 1; // Boolean is always written

      size += calculateMaxSerializedSize(sourceName.getName());
      size += calculateMaxSerializedSize(sourceName.getNamedExtensions());

      return size;
   }
}
