//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: May 16, 2007
//---------------------

package org.cleversafe.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

/**
 * This class stores all the variables related to the state of a clients
 * session with a server.
 *
 */
public class ClientSession
{
   // Session variable names are to be named here                         Object Type:
   public static final String APPLICATION_TYPE = "_application_type";     // ApplicationType
   public static final String GRID_ACCOUNT_UUID = "_grid_account_uuid";   // UUID
   public static final String SLICE_STORE = "_slice_store";               // SliceStore
   public static final String VAULT_UUID = "_vault_uuid";                 // UUID
   public static final String VAULT_PERMISSION = "_vault_permission";     // VaultPermission
   public static final String AUTHENTICATED = "_authenticated";           // boolean
   public static final String WRITE_PERMISSION = "_write_permission";     // boolean
   public static final String READ_PERMISSION = "_read_permission";       // boolean
   public static final String LIST_PERMISSION = "_list_permission";       // boolean
   // End session variable names
   
   private Map<String, Object> keyValuePairs;
   
   /**
    * Default Constructor
    */
   public ClientSession()
   {
      this.keyValuePairs = Collections.synchronizedMap(new HashMap<String, Object>());
   }
   
   /**
    * Wraps the containsKey method of the HashMap
    * 
    * @param key
    * @return true if session map contains key
    * @see Map.containsKey
    */
   public boolean containsKey( String key )
   {
      return this.keyValuePairs.containsKey(key);
   }
   
   /**
    * Wraps the put method of the HashMap
    * 
    * @param key
    * @param obj
    * @return value stored in the session map
    * @see Map.put
    */
   public Object put( String key, Object obj )
   {
      return this.keyValuePairs.put(key, obj);
   }
   
   /**
    * Wraps the get method of the HashMap
    * 
    * @param key
    * @return the value of the key in the session map
    * @see Map.get
    */
   public Object get( String key )
   {
      return this.keyValuePairs.get(key);
   }
   
   /**
    * Wraps the remove method of the HashMap
    * 
    * @param key
    * @return the value of the key in the session map, or null if non-existent
    * @see Map.remove
    */
   public Object remove( String key )
   {
      return this.keyValuePairs.remove(key);
   }
   public String toString()
   {
      StringBuffer res = new StringBuffer();
      res.append("SESSION[");
      // use selected properties to display
      Object vaultUUID = this.keyValuePairs.get(VAULT_UUID);
      res.append("VAULT=");
      if (vaultUUID != null)
      {
         res.append(vaultUUID.toString());
      }
      else
      {
         res.append("UNKNOWN");
      }
      Object accountUUID = this.keyValuePairs.get(GRID_ACCOUNT_UUID);
      res.append(" ACCOUNT=");
      if (accountUUID != null)
      {
         res.append(accountUUID.toString());
      }
      else
      {
         res.append("UNKNOWN");
      }
      res.append("]");
      return res.toString();
   }

}


