//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: Jason Resch
//
// Date: May 16, 2007
//---------------------

package org.cleversafe.server;

import java.util.List;

import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.vault.exceptions.VaultException;

/**
 * Interface for RequestHandlers, the type of object that is registered with a ServerApplication and
 * gets called when a request that matches getRequestClass() comes in. In that event the request
 * along with the client's session will be sent to the service() method. Requests also define a list
 * of supported applications, used by the server to verify the client has the necessary permission
 * and is of the appropriate type to be called.
 */
public interface RequestHandler
{
   /**
    * Returns the class type for the request this handler is responsible for, this is used to create
    * the server's map of request types to handlers
    * 
    * @return class type for the request this handler is responsible for
    */
   public Class<? extends Request> getRequestClass();

   /**
    * Returns a list of ApplicationTypes that are authorized to call this handler
    * 
    * @return list of ApplicationTypes that are authorized to call this handler
    */
   public List<ApplicationType> getAllowedApplications();

   /**
    * Services the request and returns a response
    * 
    * @param request
    * @param session
    * @return an appropriate response for the given request
    * @throws ProtocolLayerException
    * @throws SliceStoreLayerException
    * @throws ServerException
    * @throws VaultException
    */
   public <T extends Request> Response service(T request, ClientSession session)
         throws ProtocolLayerException, SliceStoreLayerException, ServerException, VaultException;

}
