//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: mmotwani
//
// Date: Jul 25, 2007
//---------------------

package org.cleversafe.server.exceptions;

import org.cleversafe.layer.protocol.ProtocolOperation;
import org.cleversafe.layer.protocol.Request;

/**
 * Exception is thrown when a problem with a Request is responsible for an
 *  exception being thrown
 *  
 *  @see ServerException
 */
public class ServerRequestException extends ServerException
{
   private static final long serialVersionUID = 5893470012396482308L;

   protected ProtocolOperation operation;

   /**
    * Constructs object taking only a reason
    * 
    * @param reason
    * @see ServerException
    */
   public ServerRequestException(String reason)
   {
      super(reason);
      this.operation = null;
   }

   /**
    * Constructs object taking a reason and a request
    * 
    * @param reason
    * @param request
    * @see ServerException
    */
   public ServerRequestException(String reason, Request request)
   {
      super(reason);
      this.operation = request.getOperation();
   }

   /**
    * Constructs object taking a reason, request, and cause
    * 
    * @param reason
    * @param request
    * @param cause
    * @see ServerException
    */
   public ServerRequestException(String reason, Request request, Throwable cause)
   {
      super(reason, cause);
      this.operation = request.getOperation();
   }

   /**
    * Setter for operation
    * 
    * @param operation
    */
   public void setOperation(ProtocolOperation operation)
   {
      this.operation = operation;
   }

   /**
    * Getter for operation
    * 
    * @return protocol operation
    */
   public ProtocolOperation getOperation()
   {
      return this.operation;
   }
}
