//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zach
//
// Date: Sep 11, 2007
//---------------------

package org.cleversafe.server.handlers.version;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;
import org.cleversafe.layer.protocol.GetSupportedProtocolVersionsRequest;
import org.cleversafe.layer.protocol.GetSupportedProtocolVersionsResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ApplicationType;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.RequestHandler;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.vault.exceptions.VaultException;

/**
 * Handler for GetSupportedProtocolVersionsRequest message
 * 
 * @author Zach
 */
public class GetSupportedProtocolVersionsHandler implements RequestHandler
{
   private static Logger _logger = Logger.getLogger(GetSupportedProtocolVersionsHandler.class);

   private final List<ApplicationType> _allowedApplications;

   private Map<Short, List<Short>> versionMap = null;

   /**
    * Constructor which initializes the compatible version map.
    * 
    * @param versionMap
    *           The compatible version map.
    */
   public GetSupportedProtocolVersionsHandler(Map<Short, List<Short>> versionMap)
   {
      // discard of basePath
      this._allowedApplications = new ArrayList<ApplicationType>();
      this._allowedApplications.add(ApplicationType.TYPE_ANY);
      this.versionMap = versionMap;
   }

   /**
    * Returns a list of application types that can access this handler
    * 
    * @see RequestHandler.getAllowedApplications()
    */
   public List<ApplicationType> getAllowedApplications()
   {
      return this._allowedApplications;
   }

   /**
    * Returns class for the type of message this handler services
    * 
    * @see RequestHandler.getRequestClass()
    */
   public Class<GetSupportedProtocolVersionsRequest> getRequestClass()
   {
      return GetSupportedProtocolVersionsRequest.class;
   }

   /**
    * Returns a GetSupportedProtocolVersionsResponse containing a list of supported protocol
    * versions
    * 
    * @see RequestHandler.service(Request request, ClientSession session)
    */
   public Response service(Request request, ClientSession session) throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      assert request instanceof GetSupportedProtocolVersionsRequest;

      GetSupportedProtocolVersionsResponse response = new GetSupportedProtocolVersionsResponse();
      Short protocolID = new Short(((GetSupportedProtocolVersionsRequest) request).getProtocolID());

      List<Short> versionList = null;
      if (this.versionMap.containsKey(protocolID))
      {
         versionList = this.versionMap.get(protocolID);
      }
      _logger.debug("Got version compatibility map for version " + protocolID.toString());

      response.setVersionList(versionList);

      return response;
   }

}
