//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zach
//
// Date: Sep 11, 2007
//---------------------

package org.cleversafe.server.handlers.version;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.protocol.GetSupportedProtocolsRequest;
import org.cleversafe.layer.protocol.GetSupportedProtocolsResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.cleversafe.layer.protocol.exceptions.ProtocolLayerException;
import org.cleversafe.layer.slicestore.exceptions.SliceStoreLayerException;
import org.cleversafe.server.ApplicationType;
import org.cleversafe.server.ClientSession;
import org.cleversafe.server.RequestHandler;
import org.cleversafe.server.exceptions.ServerException;
import org.cleversafe.vault.exceptions.VaultException;

/**
 * Handler for GetSupportedProtocolsRequest message
 * 
 * @author Zach
 */
public class GetSupportedProtocolsHandler implements RequestHandler
{
   private final List<ApplicationType> _allowedApplications;

   private List<Short> protocolList = null;

   /**
    * Constructs object and creates allowed applications access control list saving a reference to
    * the supported protocol list
    */
   public GetSupportedProtocolsHandler(List<Short> protocolList)
   {
      // discard of basePath
      this._allowedApplications = new ArrayList<ApplicationType>();
      this._allowedApplications.add(ApplicationType.TYPE_ANY);
      this.protocolList = protocolList;
   }

   /**
    * Returns a list of application types that can access this handler
    * 
    * @see RequestHandler.getAllowedApplications()
    */
   public List<ApplicationType> getAllowedApplications()
   {
      return this._allowedApplications;
   }

   /**
    * Returns class for the type of message this handler services
    * 
    * @see RequestHandler.getRequestClass()
    */
   public Class<GetSupportedProtocolsRequest> getRequestClass()
   {
      return GetSupportedProtocolsRequest.class;
   }

   /**
    * Returns a GetSupportedProtocolsResponse containing a list of supported protocols
    * 
    * @see RequestHandler.service(Request request, ClientSession session)
    */
   public Response service(Request request, ClientSession session) throws ProtocolLayerException,
         SliceStoreLayerException, ServerException, VaultException
   {
      GetSupportedProtocolsResponse response = new GetSupportedProtocolsResponse(this.protocolList);

      return response;
   }

}
