//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zachary Mark
//
// Date: Nov 1, 2007
//---------------------

package org.cleversafe.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

// TODO: Describe class or interface
public class FileSystemUtils
{
   /**
    * Moves a file from srcFile to folder destFolder.  If destFolder does not
    * exist, create it.
    * 
    * @param srcFile
    * @param destFolder
    * @throws IOException
    */
   public static void fileMove(File srcFile, File destFolder) throws IOException
   {
      if (!srcFile.exists())
      {
         // throw an exception
      }
      if (destFolder.exists() && destFolder.isFile())
      {
         // throw an exception
      }

      if (!destFolder.exists())
      {
         destFolder.mkdirs();
      }

      FileInputStream inFile = new FileInputStream(srcFile);
      String dest = destFolder.getPath() + File.separator + srcFile.getName();
      FileOutputStream outFile = new FileOutputStream(dest);

      FileSystemUtils.fileCopy(inFile, outFile);
      if (!srcFile.delete())
      {
         // throw an exception
      }
   }

   /**
    * Copy a file from inFile to outFile. Assumes both streams are open already and that inFile is
    * finite.
    */
   public static void fileCopy(InputStream inFile, OutputStream outFile) throws IOException
   {
      byte[] buf = new byte[1024];
      int len = 0;
      while ((len = inFile.read(buf)) > 0)
      {
         outFile.write(buf, 0, len);
      }
      inFile.close();
      outFile.close();
   }
   
   /**
    * Reads a complete file in as a string.
    * 
    * @param file The file to read in.
    * @return A string containing the contents of the file.
    * @throws IOException
    */
   public static String readFileAsString(File file) throws IOException
   {
      StringBuffer fileData = new StringBuffer(1000);
      BufferedReader reader = new BufferedReader(new FileReader(file));
      char[] buf = new char[1024];
      int numRead = 0;
      while ((numRead = reader.read(buf)) != -1)
      {
         String readData = String.valueOf(buf, 0, numRead);
         fileData.append(readData);
         buf = new char[1024];
      }
      reader.close();
      return fileData.toString();
   }
   
   /**
    * Deletes a directory containing files.
    */
   public static boolean deleteDir(File dir)
   {
      if (dir.isDirectory())
      {
         String[] children = dir.list();
         for (int i = 0; i < children.length; i++)
         {
            boolean success = deleteDir(new File(dir, children[i]));
            if (!success)
            {
               return false;
            }
         }
      }

      // The directory is now empty so delete it
      return dir.delete();
   }
   
   public static boolean compareInputStreams(InputStream right, InputStream left) throws IOException
   {
      if (right == left)
      {
         return true;
      }
      else if (right == null && left == null)
      {
         return true; // neither has contents
      }
      else if (right == null || left == null)
      {
         return false;
      }

      byte[] rbuf = new byte[4096];
      byte[] lbuf = new byte[rbuf.length];
      int len = 0;

      while ((len = right.read(rbuf)) > 0)
      {
         if ((left.read(lbuf)) != len)
         {
            return false;
         }
         if (!Arrays.equals(rbuf, lbuf))
         {
            return false;
         }
      }

      return true;
   }
   
   
   
}
