//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Sep 16, 2007
//---------------------

package org.cleversafe.util;
import java.io.File;

import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class Log4jReloader
{
   private static Logger _logger = Logger.getLogger(Log4jReloader.class);
   private static boolean launchFlag = false;
   
   private static int tryTimeout = 3000;
   private static String tryTimeoutProperty = "com.cleversare.log4.timeout";
   private static String log4jDefaultProperty = "log4j.configuration";
   
   static public boolean launch (final String log4jConfig)
   {
      synchronized (Log4jReloader.class)
      {
         if (launchFlag == true)
         {
            return false;
         }
         launchFlag = true;
      }
      tryTimeout = Integer.getInteger(tryTimeoutProperty, tryTimeout);
      
      final Thread log4Thread = new Thread("log4j-config-Poller")
      {
         public void run()
         {
            File log4j =
                  new File(log4jConfig);
            long lastModified = log4j.lastModified();

            while (true)
            {
               try
               {
                  Thread.sleep(tryTimeout);
               }
               catch (InterruptedException e)
               {
                  // TODO Auto-generated catch block
                  e.printStackTrace();
               }
               long lastModifiedNew = log4j.lastModified();
               if (lastModified < lastModifiedNew)
               {
                  lastModified = lastModifiedNew;
                  _logger.info("Detected change in " + log4jConfig + ". Reconfiguring...");
                  DOMConfigurator.configure(log4jConfig);
               }
            }
         }
      };
      log4Thread.setDaemon(true);
      log4Thread.start();

      return true;
   }
   static public boolean launch ()
   {
      if (System.getProperty("log4j.configuration") == null)
      {
         return false;
      }
      return launch(System.getProperty("log4j.configuration"));
   }
}


