//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Aug 23, 2007
//---------------------

package org.cleversafe.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Helper factory for a named thread pool
 */
public class NamedThreadFactory implements ThreadFactory
{
   // Name prefix (eg. MyPool)
   protected String prefix;
   
   // Priority of threads created by this factory
   protected int priority;

   // Number of threads this factory has created
   protected AtomicInteger numThreads;

   // Base factory implementation
   protected ThreadFactory impl;
   
   // Make threads daemons
   protected boolean daemon;

   /**
    * Construct a new NamedFactory with the following prefix for each thread it creates
    * 
    * @param prefix
    */
   public NamedThreadFactory(String prefix)
   {
      this(prefix, Thread.currentThread().getPriority());
   }
   
   /**
    * Construct a new NamedFactory with the following prefix for each thread it creates
    * 
    * @param prefix
    */
   public NamedThreadFactory(String prefix, boolean daemon)
   {
      this(prefix, Thread.currentThread().getPriority(), daemon);
   }
   
   /**
    * Construct a new NamedFactory with the following prefix for each thread it creates
    * 
    * @param prefix
    * @param priority Priority of threads created by this factory
    */
   public NamedThreadFactory(String prefix, int priority)
   {
      this.prefix = prefix;
      this.priority = priority;

      this.numThreads = new AtomicInteger();
      impl = Executors.defaultThreadFactory();
      this.daemon = false;
   }
   
   /**
    * Construct a new NamedFactory with the following prefix for each thread it creates
    * 
    * @param prefix
    * @param priority Priority of threads created by this factory
    */
   public NamedThreadFactory(String prefix, int priority, boolean daemon)
   {
      this.prefix = prefix;
      this.priority = priority;

      this.numThreads = new AtomicInteger();
      impl = Executors.defaultThreadFactory();
      this.daemon = daemon;
   }

   public Thread newThread(Runnable r)
   {
      int threadNum = this.numThreads.incrementAndGet();
      Thread t = this.impl.newThread(r);
      t.setName(this.prefix + ": " + threadNum);
      t.setPriority(this.priority);
      t.setDaemon(this.daemon);
      return t;
   }
}
