//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: gdhuse
//
// Date: Aug 29, 2007
//---------------------

package org.cleversafe.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * Executor without any threads -- all tasks are run in the submitting thread
 */
public class ThreadlessExecutor extends AbstractExecutorService
{
   // Is this executor done with all tasks?
   private boolean isTerminated = false;

   // Condition object for synchronizing termination
   private Object terminationCondition = new Object();

   public boolean awaitTermination(long arg0, TimeUnit arg1) throws InterruptedException
   {
      boolean success = false;

      synchronized (this.terminationCondition)
      {
         if (!this.isTerminated)
         {
            this.terminationCondition.wait(arg1.toMillis(arg0));
            success = this.isTerminated;
         }
      }

      return success;
   }

   public boolean isShutdown()
   {
      synchronized (this.terminationCondition)
      {
         return this.isTerminated;
      }
   }

   public boolean isTerminated()
   {
      synchronized (this.terminationCondition)
      {
         return this.isTerminated;
      }
   }

   public void shutdown()
   {
      // Blocks until any running tasks are complete
      synchronized (this.terminationCondition)
      {
         this.isTerminated = true;
         this.terminationCondition.notify();
      }
   }

   public List<Runnable> shutdownNow()
   {
      // Nothing to do
      return new ArrayList<Runnable>();
   }

   public void execute(Runnable arg0)
   {
      assert !this.isTerminated;

      synchronized (this.terminationCondition)
      {
         arg0.run();
      }
   }
}
