//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Aug 5, 2007
//---------------------

package org.cleversafe.util;
import org.apache.log4j.Logger;

// Utility to generate universally unique transaction id
/*
 * It may slow down significantly if too many simultanious requests
 * for id are performed. In real time situation it should not effect much of anything
 * However, accordiing to bug
 * http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6313903
 * Thread.sleep(1) may return on Windows immediately
 * On the other hand it takes 16msec in my mesurement to move to another time
 * So if you run this code 1000 times it takes about 16 sec to execute, crazy isn't
 */
public class TransactionIdGenerator
{
   private static Logger _logger = Logger.getLogger(TransactionIdGenerator.class);

   static private long lastGeneratedId = -1;
   
   static public synchronized long generate()
   {
      // Should be executed no more then twice, nut reality is different. see above
      while (true) {  
         long id = System.currentTimeMillis();
         if (id > lastGeneratedId)
         {
            lastGeneratedId = id;
            
            if (_logger.isTraceEnabled())
            {
               _logger.trace("Transaction Id=" + id);
            }
            
            return id;
         }
         try
         {
            //Thread.sleep(1);
            java.util.concurrent.TimeUnit.MILLISECONDS.sleep(1);
         }
         catch (InterruptedException ignore)
         {}
      }
   }
}


