//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: gdhuse
//
// Date: May 25, 2007
//---------------------

package org.cleversafe.util;

/**
 * Simple parameterized container similar to STL pair
 * @param <T1> Type of first element
 * @param <T2> Type of second element
 * @param <T3> Type of third epement
 */
public class Tuple3<T1,T2,T3>
{
   private final T1 first;
   private final T2 second;
   private final T3 third;

   public T1 getFirst()
   {
      return this.first;
   }

   public T2 getSecond()
   {
      return this.second;
   }
   
   public T3 getThird()
   {
      return this.third;
   }

  public Tuple3(final T1 first, final T2 second, final T3 third)
   {
      this.first = first;
      this.second = second;
      this.third = third;
   }

   public static <T1,T2,T3> Tuple3<T1,T2,T3> create(T1 first, T2 second, T3 third)
   {
      return new Tuple3<T1,T2,T3>(first, second, third);
   }

   public final boolean equals(Object o)
   {
      if (!(o instanceof Tuple3))
         return false;

      final Tuple3<?, ?, ?> other = (Tuple3<?, ?, ?>) o;
      return equal(getFirst(), other.getFirst())
            && equal(getSecond(), other.getSecond())
            && equal(getThird(), other.getThird());
   }

   public static final boolean equal(Object o1, Object o2)
   {
      if (o1 == null)
      {
         return o2 == null;
      }
      return o1.equals(o2);
   }

   public int hashCode()
   {
      int hFirst  = getFirst() == null ? 0 : getFirst().hashCode();
      int hSecond = getSecond() == null ? 0 : getSecond().hashCode();
      int hThird  = getThird() == null ? 0 : getThird().hashCode();

      return hFirst + (57 * hSecond) + (103 * hThird);
   }
   public String toString()
   {
      return "[" + getFirst() + "," + getSecond() + "," + getThird() + "]";
   }
   
}
