//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: Zach
//
// Date: Sep 13, 2007
//---------------------

package org.cleversafe.util.httpserver;

import org.cleversafe.util.httpserver.exceptions.ServerStartFailedException;
import org.cleversafe.util.httpserver.exceptions.ServerStopFailedException;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.webapp.WebAppContext;

public class JettyHttpServletServer implements HttpServletServer
{
   private String bindAddress = "127.0.0.1";
   private int bindPort = 8166;

   private Server jettyHttpServer = null;

   /**
    * Get the address to which the server binds.
    * 
    * @return The IP address.
    */
   public String getBindAddress()
   {
      return bindAddress;
   }

   /**
    * Set the address to which the server binds.
    * 
    * @param The IP address.
    */
   public void setBindAddress(String bindAddress)
   {
      this.bindAddress = bindAddress;
   }

   /**
    * Get the port to which the server binds.
    * 
    * @return The port number.
    */
   public int getBindPort()
   {
      return bindPort;
   }

   /**
    * Set the port to which the server binds.
    * 
    * @param The port number.
    */
   public void setBindPort(int bindPort)
   {
      this.bindPort = bindPort;
   }

   /**
    * Default constructor.  Default address is localhost and default port is 8166. 
    * 
    */
   public JettyHttpServletServer()
   {
   }

   /**
    * Constructor to initialize the address and port.
    * 
    * @param bindAddress Address to which to bind the server.
    * @param bindPort Port to which the server binds.
    */
   public JettyHttpServletServer(String bindAddress, int bindPort)
   {
      this.bindAddress = bindAddress;
      this.bindPort = bindPort;
      this.jettyHttpServer = new Server();
   }

   public void start() throws ServerStartFailedException
   {
      Connector connector = new SelectChannelConnector();
      connector.setPort(bindPort);
      connector.setHost(bindAddress);
      jettyHttpServer.addConnector(connector);

      this.jettyHttpServer.setStopAtShutdown(true);

      try
      {
         this.jettyHttpServer.start();
      }
      catch (Exception e)
      {
         throw new ServerStartFailedException("Could not start Jetty", e);
      }
   }

   public void registerWar(String warPath, String webPath)
   {
      WebAppContext wac = new WebAppContext();
      wac.setContextPath(webPath);
      wac.setWar(warPath);
      this.jettyHttpServer.addHandler(wac);
   }

   public void stop() throws ServerStopFailedException
   {
      try
      {
         this.jettyHttpServer.stop();
      }
      catch (Exception e)
      {
         throw new ServerStopFailedException("Could not stop Jetty", e);
      }
   }

   /**
    * Quick test application to make sure Jetty works.
    * 
    * @throws ServerStartFailedException
    */
   public static void main(String[] args) throws ServerStartFailedException
   {
      JettyHttpServletServer jetty = new JettyHttpServletServer("127.0.0.1", 8166);
      jetty.registerWar("test-data/org/cleversafe/util/httpserver/foobar.war", "/test");
      jetty.start();
      while (true);
   }
}
