//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: mmotwani
//
// Date: Jun 15, 2007
//---------------------

package org.cleversafe.vault;

import java.io.File;
import java.util.List;

import org.cleversafe.codec.Codec;
import org.cleversafe.config.ExecutionContext;
import org.cleversafe.config.evaluator.NamedEvaluator;
import org.cleversafe.ida.InformationDispersalCodec;
import org.cleversafe.layer.slicestore.SliceStore;
import org.cleversafe.vault.exceptions.VaultACLException;
import org.cleversafe.vault.exceptions.VaultDescriptorException;
import org.cleversafe.vault.exceptions.VaultIOException;

// TODO: Describe class or interface
public interface VaultDescriptor
{
   public static final String ACL_CTX_STRING = "acl";
   public static final String ACL_ENTRY_CTX_STRING = "acl-entry";
   public static final String CREDENTIALS_CTX_STRING = "credentials";

   public String getVaultType();

   public List<NamedEvaluator> getVaultParameters() throws VaultDescriptorException;

   public List<Codec> getDatasourceCodecs() throws VaultDescriptorException, VaultACLException;

   public List<Codec> getSliceCodecs() throws VaultDescriptorException, VaultACLException;

   public InformationDispersalCodec getInformationDispersalCodec() throws VaultDescriptorException;

   public List<SliceStore> getSliceStores() throws VaultDescriptorException;

   public ExecutionContext getExecutionContext();

   /**
    * HACK. SHOULD BE FIXED IN >1.0 Don't load slice stores. Fails on repair
    * 
    * @return
    * @throws VaultDescriptorException
    * @throws VaultACLException
    */
   public Vault createNoSliceStoreVaultObject() throws VaultDescriptorException, VaultACLException;

   public Vault createVaultObject() throws VaultDescriptorException, VaultACLException;

   /**
    * Write the vault descriptor to a file.
    * 
    * @param loc
    *           File location at which to write the vault descriptor
    * @throws VaultDescriptorException
    * @throws VaultIOException
    */
   public void writeDescriptor(File loc) throws VaultDescriptorException, VaultIOException;
}
