//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: ivolvovski
//
// Date: Jun 16, 2007
//---------------------

package org.cleversafe.vault;

import java.io.File;
import java.io.InputStream;
import java.util.UUID;

import org.cleversafe.util.FileResolver;
import org.cleversafe.util.exceptions.ResolutionException;


// Resolves vault descriptor from a file
// By default searches in a home directory. Can be overwritten through properties
public class VaultFileResolver implements VaultResolver
{
   public static final String SYSTEM_HOME_DIR_PROPERTY = "user.home";
   public static final String VAULT_FILE_LOCATION = "org.cleversafe.vaultlocation";
   public static final String VAULT_FILE_EXTENSION = ".xml";
   public static final String VAULT_ACL_FILE_EXTENSION = ".acl";
   public static final String DEFAULT_VAULT_CONF_DIR = "vaults";
   public static final String DEFAULT_VAULT_DIR = "/etc/dsgrid/" + DEFAULT_VAULT_CONF_DIR;

   public InputStream getVaultDefinition(UUID vaultId) throws ResolutionException
   {  
      String defaultPath = DEFAULT_VAULT_DIR + File.separator + vaultId + VAULT_FILE_EXTENSION;
      String otherPath = null;
      if (System.getProperty(VaultFileResolver.VAULT_FILE_LOCATION) != null)
      {
         otherPath = System.getProperty(VaultFileResolver.VAULT_FILE_LOCATION) + 
                       File.separator + vaultId + VAULT_FILE_EXTENSION;
      }
      return new FileResolver(VAULT_FILE_LOCATION, new File(defaultPath), new File(otherPath)).getInputStream();
   }

   
   public InputStream getVaultACL(UUID vaultId) throws ResolutionException
   {
      String defaultPath = DEFAULT_VAULT_DIR + File.separator + vaultId + VAULT_FILE_EXTENSION;
      String otherPath = null;
      if (System.getProperty(VaultFileResolver.VAULT_FILE_LOCATION) != null)
      {
         otherPath = System.getProperty(VaultFileResolver.VAULT_FILE_LOCATION) + 
                       File.separator + vaultId + VAULT_ACL_FILE_EXTENSION;
      }
      return new FileResolver(VAULT_FILE_LOCATION, new File(defaultPath), new File(otherPath)).getInputStream();
   }
   
   
}
