//
// Cleversafe open-source code header - Version 1.2 - February 15, 2008
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2008 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 224 North Desplaines Street, Suite 500 
// Chicago IL 60661
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// Author: wleggette
//
// Date: Dec 5, 2007
//---------------------

package org.cleversafe.vault.managers.state;
import java.util.UUID;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;


@Entity
@Table(name = "VAULT")
public class VaultState
{
   @Id @GeneratedValue
   @Column(name = "VAULT_ID", nullable = false)
   private int id;
   
   @Column(name = "VAULT_IDENTIFIER", unique = true)
   private String identifier;
   
   @Column(name = "VAULT_NAME", unique = true)
   private String name;
   
   public VaultState() {}
   public VaultState(UUID vaultIdentifier, String vaultName)
   {
      this.identifier = vaultIdentifier.toString();
      this.name = vaultName;
   }
   public int getId()
   {
      return id;
   }
   public void setId(int id)
   {
      this.id = id;
   }
   public UUID getIdentifier()
   {
      return UUID.fromString(this.identifier);
   }
   public void setIdentifier(UUID vaultIdentifier)
   {
      this.identifier = vaultIdentifier.toString();
   }
   public void setIdentifier(String vaultIdentifier)
   {
      this.identifier = vaultIdentifier;
   }
   public String getName()
   {
      return name;
   }
   public void setName(String vaultName)
   {
      this.name = vaultName;
   }
   
   @Override
   public String toString()
   {
      return "<Vault name=" + this.name + ", uuid=" + this.identifier + ">";
   }
   @Override
   public int hashCode()
   {
      final int prime = 31;
      int result = 1;
      result = prime * result + ((identifier == null) ? 0 : identifier.hashCode());
      return result;
   }
   @Override
   public boolean equals(Object obj)
   {
      if (this == obj)
         return true;
      if (obj == null)
         return false;
      if (getClass() != obj.getClass())
         return false;
      final VaultState other = (VaultState) obj;
      if (identifier == null)
      {
         if (other.getIdentifier() != null)
            return false;
      }
      else if (!identifier.equals(other.getIdentifier()))
         return false;
      return true;
   }
   
   
   
   
   
   

}

