//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 9, 2007
//---------------------

package org.cleversafe.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.xml.DOMConfigurator;

public class FixedErrorRateSelectorTest
{
   static final double[] ERROR_PROBABILITY = new double[]{
         //  1     2     3     4      5     6     7     8     9     10    11    12    13    14    15   
         0.00, 0.00, 0.001, 0.002, 0.003, 0.007, 0.01, 0.02, 0.1
   };

   public static void main(String[] args)
   {
      DOMConfigurator.configure(System.getProperty("log4j.configuration"));

      final int ATTEMPTS = 1000000;

      final int MINIMAL_SINGLE_ATTEMPT = 10;
      final double ERROR_PUNISHMENT[] = new double[]{
            //            0.0, 0.01, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 10.0
            0, 0.0001, 0.01, 0.1, 0.5, 1.0, 3.0, 9.0
            
      };
      final double MAX_TOLERABLE_RATE = 0.003; //1.0 this value would eliminate self corrections
      final double MIN_SENSITIVE_RATE = 0.001; //0.0
      final int MIN_ATTEMPTS_TO_RATE = 100; // Min # of attempts for which error rate start kicking in
      final double PUNISHMENT_ADJUSTMENT_VALUE = 1.1;

      for (double initialPunsishValue : ERROR_PUNISHMENT)
      {
         FixedErrorRateSelector selector =
               new FixedErrorRateSelector(new IntegerRangeParameter(1, 1, 32), MINIMAL_SINGLE_ATTEMPT,
                     initialPunsishValue, PUNISHMENT_ADJUSTMENT_VALUE, MAX_TOLERABLE_RATE,
                     MIN_SENSITIVE_RATE, MIN_ATTEMPTS_TO_RATE);
         
         // Basic simulation
         List<Integer> stateCounter = new ArrayList<Integer>();

         for (int i = 0; i < ATTEMPTS; i++)
         {
            IntegerRangeParameter state = (IntegerRangeParameter)selector.getState();
            if (state.getStateValue() >= stateCounter.size())
            {
               for (int j = stateCounter.size(); j <= state.getStateValue(); j++)
               {
                  stateCounter.add(0);
               }
            }
            stateCounter.set(state.getStateValue(), stateCounter.get(state.getStateValue()) + 1);
            double r = Math.random();
            if (state.getStateValue() < ERROR_PROBABILITY.length
                  && r > ERROR_PROBABILITY[state.getStateValue()])
            {
               selector.onSuccess();
            }
            else
            {
               selector.onFailure();
            }
         }
         // Simulation results
         double averageSize = 0; // Average state value
         for (int i = 0; i < stateCounter.size(); i++)
         {
            averageSize += (i + 1) * stateCounter.get(i);
         }
         averageSize /= ATTEMPTS;

         FixedErrorRateSelector.Statistics statistics = selector.getStatistics();
         System.out.print(String.format(
               "P:%-6.4f ([%-4.2e %-6.1f %-4.2e] {%4d,%4d}) Average:%-5.2f Error:%-5.2f%%", 
               initialPunsishValue,
               statistics.getPunishMin(),statistics.getPunishMax(), statistics.getPunishAverage(), 
               statistics.getPunishInc(), statistics.getPunishDec(), averageSize,
               (statistics.getErrorCounter() * 100.0) / statistics.getAttempts()));

         Map<ParameterState, FixedPunishmentSelector.ParameterRuntime> situationMap = selector.getCurrentResults();
         Set<ParameterState> states = situationMap.keySet();
         int i = 0;
         for (ParameterState s : states)
         {
            i++;
            System.out.print(String.format("\t%d.(%5.2f%% %-6d) ", i,
                  (stateCounter.get(i) * 100.0) / ATTEMPTS, situationMap.get(s).getCumulativeErrors()));
         }
         System.out.println();
      }
   }
}
