//
// Cleversafe open-source code header - Version 1.1 - December 1, 2006
//
// Cleversafe Dispersed Storage(TM) is software for secure, private and
// reliable storage of the world's data using information dispersal.
//
// Copyright (C) 2005-2007 Cleversafe, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
// USA.
//
// Contact Information: Cleversafe, 10 W. 35th Street, 16th Floor #84,
// Chicago IL 60616
// email licensing@cleversafe.org
//
// END-OF-HEADER
//-----------------------
// @author: ivolvovski
//
// Date: Dec 9, 2007
//---------------------

package org.cleversafe.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.cleversafe.control.FixedPunishmentSelector.ParameterRuntime;

public class FixedPunishmentTest
{
   static final double[] ERROR_PROBABILITY = new double[]{
         //  1     2     3     4      5     6     7     8     9     10    11    12    13    14    15   
         0.00, 0.00, 0.00, 0.001, 0.03, 0.05, 0.06, 0.20
   //, 0.25, 0.30, 0.50, 0.60, 0.70, 0.85, 0.90
         // supposedly fast
         //0.00, 0.03, 0.20, 0.30, 0.50, 0.60, 0.70, 0.85, 0.90
         // supposedly slow
         };

   /**
    * @param args
    */
   public static void main(String[] args)
   {
      final int ATTEMPTS = 100000;
      final int MINIMAL_SINGLE_ATTEMPT = 10;
      final double ERROR_PUNISHMENT[] = new double[]{
            //            0.0, 0.01, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 10.0
            1.e-100, 0.0001, 0.01, 0.1, 0.5, 1.0, 3.0, 9.0
      };


      for (double punish : ERROR_PUNISHMENT)
      {
         int errorCounter = 0;

         FixedPunishmentSelector selector =
               new FixedPunishmentSelector(new IntegerRangeParameter(1, 1, 32), MINIMAL_SINGLE_ATTEMPT,
                     punish);

         // Basic simulation
         List<Integer> stateCounter = new ArrayList<Integer>();

         for (int i = 0; i < ATTEMPTS; i++)
         {
            IntegerRangeParameter state = (IntegerRangeParameter) selector.getState();
            if (state.getStateValue() >= stateCounter.size())
            {
               for (int j = stateCounter.size(); j <= state.getStateValue(); j++)
               {
                  stateCounter.add(0);
               }
            }
            stateCounter.set(state.getStateValue(), stateCounter.get(state.getStateValue()) + 1);
            double r = Math.random();
            if (state.getStateValue() < ERROR_PROBABILITY.length
                  && r > ERROR_PROBABILITY[state.getStateValue()])
            {
               selector.onSuccess();
            }
            else
            {
               errorCounter++;
               selector.onFailure();
            }
         }

         // Simulation results
         double averageSize = 0; // Average state value
         for (int i = 0; i < stateCounter.size(); i++)
         {
            averageSize += (i + 1) * stateCounter.get(i);
         }
         averageSize /= ATTEMPTS;

         System.out.print(String.format("P:%-6.4f Error:%-5.2f%% Average:%-5.3f", punish, (errorCounter * 100.0)
               / ATTEMPTS, averageSize));

         Map<ParameterState, ParameterRuntime> situationMap = selector.getCurrentResults();
         Set<ParameterState> states = situationMap.keySet();
         int i = 0;
         for (ParameterState s : states)
         {
            i++;
            System.out.print(String.format("\t%d.(%5.2f%% %-6d) ", i, (stateCounter.get(i) * 100.0)
                  / ATTEMPTS, situationMap.get(s).getCumulativeErrors()));
         }
         System.out.println();
      }
   }
}
