package org.cleversafe.protocol;

import org.cleversafe.layer.protocol.BeginTransactionRequest;
import org.cleversafe.layer.protocol.BeginTransactionResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class BeginTransactionProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      BeginTransactionRequest request = new BeginTransactionRequest();
   
      request.setTransactionID(1L);
      
      return request;
   }
   
   public Response createResponse()
   {
      BeginTransactionResponse response = new BeginTransactionResponse();
      
      return response;
   }
}