package org.cleversafe.protocol;

import org.cleversafe.layer.protocol.EndSessionRequest;
import org.cleversafe.layer.protocol.EndSessionResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class EndSessionProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 1};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      EndSessionRequest request = new EndSessionRequest();
   
      request.setSessionID(1);
      
      return request;
   }
   
   public Response createResponse()
   {
      EndSessionResponse response = new EndSessionResponse();
   
      return response;
   }
}