package org.cleversafe.protocol;

import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.ExistsRequest;
import org.cleversafe.layer.protocol.ExistsResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class ExistsProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 65, 0};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 0, 1};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      ExistsRequest request = new ExistsRequest();
      
      request.setSliceName(new SliceName("A",1));
      
      return request;
   }
   
   public Response createResponse()
   {
      ExistsResponse response = new ExistsResponse();
   
      response.setExists(true);
      
      return response;
   }
}