package org.cleversafe.protocol;

import org.cleversafe.layer.protocol.ListInProgressRequest;
import org.cleversafe.layer.protocol.ListInProgressResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class ListInProgressProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 0};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 0, 0, 1};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      ListInProgressRequest request = new ListInProgressRequest();
      
      return request;
   }
   
   public Response createResponse()
   {
      ListInProgressResponse response = new ListInProgressResponse();

      response.setListInProgress(true);
      
      return response;
   }
}