package org.cleversafe.protocol;

import java.util.ArrayList;
import java.util.List;

import org.cleversafe.layer.grid.SliceName;
import org.cleversafe.layer.protocol.MultipleRemoveRequest;
import org.cleversafe.layer.protocol.MultipleRemoveResponse;
import org.cleversafe.layer.protocol.Request;
import org.cleversafe.layer.protocol.Response;
import org.junit.Before;

public class MultipleRemoveProtocolTest extends ProtocolVerificationTest
{
   final private byte[] requestBytes = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 1, 0, 1, 65, 0, 0, 0, 0, 3, 0, 1, 66, 0, 0, 0, 0, 5, 0, 1, 67, 0};
   final private byte[] responseBytes  = {0, -54, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 1};
   
   @Before
   public void setup()
   {
      super.registerRequestBytes(requestBytes);
      super.registerResponseBytes(responseBytes);
   }
   
   public Request createRequest()
   {
      MultipleRemoveRequest request = new MultipleRemoveRequest();
   
      List<SliceName> sliceNames = new ArrayList<SliceName>();
      sliceNames.add(new SliceName("A",1));
      sliceNames.add(new SliceName("B",3));
      sliceNames.add(new SliceName("C",5));
      request.setSliceNames(sliceNames);
      
      return request;
   }
   
   public Response createResponse()
   {
      MultipleRemoveResponse response = new MultipleRemoveResponse();
      
      boolean[] slicesRemoved = new boolean[3];
      slicesRemoved[0] = true;
      slicesRemoved[1] = false;
      slicesRemoved[2] = true;
      response.setRemoved(slicesRemoved);
      
      return response;
   }
}